/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class Ink_SeqCond_HasConfigValue extends SequenceCondition;

var() String GamemodName;
var() Name ConfigName;
var() int RequiredValue;

//If checked, the check will pass if the grabbed value is this value or greater.
var() bool UseMinimum;

event Activated()
{
	local class<GameMod> GamemodClass;

	if (GamemodName != "")
		GamemodClass = class<GameMod>(class'Hat_ClassHelper'.static.ActorClassFromName(GamemodName));

	if (GamemodClass != None && ConfigName != '')
	{
		if (UseMinimum)
			OutputLinks[(GamemodClass.static.GetConfigValue(GamemodClass, ConfigName) >= RequiredValue) ? 0 : 1].bHasImpulse = true;
		else
    		OutputLinks[(GamemodClass.static.GetConfigValue(GamemodClass, ConfigName) == RequiredValue) ? 0 : 1].bHasImpulse = true;
	}
	else
		OutputLinks[1].bHasImpulse = true;
}

defaultproperties
{
	ObjName="Has Config Value"
	ObjCategory="Ink Kismet"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")

	VariableLinks.Empty
	VariableLinks(0)=(ExpectedType=class'SeqVar_Int',LinkDesc="Required Value",bWriteable=true,PropertyName=DesiredValue)
}