/**
 * This class was used in a mod that replaces the unused mail room Mission Intro, but I left it here as an example.
 * Note, this script does not automatically find the appropriate matinee, as the method for finding one varies on a
 * case-by-case basis. This script assumes you already have a pointer to the matinee you want to replace.
 */
class Drew_MatineeReplacement_Example extends Drew_MatineeReplacement_Base;

var Vector Cam1Loc, Cam2Loc;
var Rotator Cam1Rot, Cam2Rot;
var float Cam1FOV, Cam2FOV;

static function DoReplaceMatinee(SeqAct_Interp Matinee)
{
	local WorldInfo WorldInfo;
	local CameraActor Cam;
	local int VariableLink;

	Super.DoReplaceMatinee(Matinee);

	WorldInfo = class'WorldInfo'.static.GetWorldInfo();

	// Spawn a camera, and assign it to the "Cam" group.
	Cam = WorldInfo.Spawn(class'DynamicCameraActor',,, default.Cam1Loc, default.Cam1Rot,, True);
	Cam.FOVAngle = default.Cam1FOV;
	VariableLink = FindOrCreateMatineeGroupVariableLink(Matinee, "Cam");
	ClearObjectsForGroup(Matinee, VariableLink);
	AppendObjectToGroup(Matinee, VariableLink, Cam);

	// Spawn a camera, and assign it to the "Cam2" group.
	Cam = WorldInfo.Spawn(class'DynamicCameraActor',,, default.Cam2Loc, default.Cam2Rot,, True);
	Cam.FOVAngle = default.Cam2FOV;
	VariableLink = FindOrCreateMatineeGroupVariableLink(Matinee, "Cam2");
	ClearObjectsForGroup(Matinee, VariableLink);
	AppendObjectToGroup(Matinee, VariableLink, Cam);
}

defaultproperties
{
	Cam1Loc = (X=1597.237671,Y=1684.752075,Z=482.639191)
	Cam1Rot = (Pitch=-3872,Yaw=-644752,Roll=0)
	Cam1FOV = 60
	Cam2Loc = (X=1403.385864,Y=1869.951660,Z=476.325104)
	Cam2Rot = (Pitch=-1120,Yaw=-4848,Roll=0)
	Cam2FOV = 90

	// Copied from Ed, with a few touch-ups: removing redundant data like Name and ObjectArchetype, and other edits to make VSCode happy.
	Begin Object Class=InterpData Name=InterpData_0
		Begin Object Class=InterpGroup Name=InterpGroup_1
			Begin Object Class=InterpTrackMove Name=InterpTrackMove_1
				PosTrack=(Points=((InVal=1.000000,OutVal=(X=0.000000,Y=-0.000244,Z=0.000000),InterpMode=CIM_CurveBreak),(InVal=6.000000,OutVal=(X=-19.538086,Y=-138.447021,Z=-0.381470),InterpMode=CIM_CurveBreak)))
				EulerTrack=(Points=((InVal=1.000000,InterpMode=CIM_CurveBreak),(InVal=6.000000,OutVal=(X=-1.565552,Y=4.537354,Z=-14.144897),InterpMode=CIM_CurveBreak)))
				LookupTrack=(Points=((Time=1.000000),(Time=6.000000)))
				MoveFrame=IMF_RelativeToInitial
			End Object
			InterpTracks(0)=InterpTrackMove_1
			GroupName="Cam2"
			GroupColor=(B=151,G=186,R=0,A=255)
		End Object
		Begin Object Class=InterpGroupDirector Name=InterpGroupDirector_0
			Begin Object Class=InterpTrackDirector Name=InterpTrackDirector_0
				CutTrack(0)=(TargetCamGroup="Cam",ShotNumber=10)
				CutTrack(1)=(Time=2.500000,TargetCamGroup="Cam2",ShotNumber=20)
			End Object
			InterpTracks(0)=InterpTrackDirector_0
			GroupColor=(B=109,G=0,R=212,A=255)
		End Object
		Begin Object Class=InterpGroup Name=InterpGroup_0
			Begin Object Class=InterpTrackMove Name=InterpTrackMove_0
				PosTrack=(Points=((InterpMode=CIM_CurveBreak),(InVal=2.500000,OutVal=(X=-52.000732,Y=0.000244,Z=-0.000122),InterpMode=CIM_CurveBreak)))
				EulerTrack=(Points=((InterpMode=CIM_CurveBreak),(InVal=2.500000,InterpMode=CIM_CurveBreak)))
				LookupTrack=(Points=((Time=0),(Time=2.500000)))
				MoveFrame=IMF_RelativeToInitial
			End Object
			InterpTracks(0)=InterpTrackMove_0
			GroupName="Cam"
			GroupColor=(B=145,G=191,R=0,A=255)
		End Object
		InterpLength=10.000000
		InterpGroups(0)=InterpGroup_0
		InterpGroups(1)=InterpGroupDirector_0
		InterpGroups(2)=InterpGroup_1
		//SelectedFilter=InterpFilter'Engine.Default__InterpData:FilterAll'
		EdSectionEnd=6.000000
		ObjInstanceVersion=1
	End Object
	ReplacementInterpData = InterpData_0
}
