class Drew_MatineeReplacement_Base extends Object;

var InterpData ReplacementInterpData;

// Returns: VariableLinks index.
static function int FindOrCreateMatineeGroupVariableLink(SeqAct_Interp Matinee, String Group)
{
	local int i;
	i = Matinee.VariableLinks.Find('LinkDesc', Group);
	if (i == INDEX_NONE)
	{
		i = Matinee.VariableLinks.Length;
		Matinee.VariableLinks.Add(1);
		Matinee.VariableLinks[i].LinkDesc = Group;
		Matinee.VariableLinks[i].ExpectedType = class'SeqVar_Object';
		Matinee.VariableLinks[i].MinVars = 0;
	}
	return i;
}

static function ClearObjectsForGroup(SeqAct_Interp Matinee, int VariableLink)
{
	Matinee.VariableLinks[VariableLink].LinkedVariables.Length = 0;
}

static function AppendObjectToGroup(SeqAct_Interp Matinee, int VariableLink, Object Obj)
{
	local SeqVar_Object SeqVar;
	SeqVar = new class'SeqVar_Object';
	SeqVar.SetObjectValue(Obj);
	Matinee.VariableLinks[VariableLink].LinkedVariables.AddItem(SeqVar);
}

static function SetMatineeData(SeqAct_Interp Matinee)
{
	local int i;
	i = Matinee.VariableLinks.Find('LinkDesc', "Data");
	if (i == INDEX_NONE) return;
	Matinee.VariableLinks[i].LinkedVariables[0] = default.ReplacementInterpData;
}

static function DoReplaceMatinee(SeqAct_Interp Matinee)
{
	SetMatineeData(Matinee);
}
