/**
 *
 * ORIGINAL Hat_PlatformDisappear SCRIPT: Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 *
 * Modified version Frog_PlatformDisappear_FixedRestart created by Dr. Treefrog.
 *
 */

class Frog_PlatformDisappear_FixedRestart extends Hat_Platform_Base
    placeable;
    
var() StaticMeshComponent Mesh;
var() const editconst LightEnvironmentComponent LightEnvironment;
var() float DisappearTime;
var() float DisappearDelay;
var() float DisappearDuration;

var float Scale;
var bool Activated;


//DRTREEFROG-ADD: Modify these values in Tick instead of DisappearDelay and DisappearDuration in order to preserve the modified values of DisappearDelay and DisappearDuration
var float CurrentDisappearDelay;
var float CurrentDisappearDuration;
    
defaultproperties
{
   Begin Object Class=StaticMeshComponent Name=Model0
		bUsePrecomputedShadows=TRUE
		LightingChannels = (Static=True,Dynamic=True)
   End Object
   Mesh=Model0
   CollisionComponent=Model0
   Components.Add(Model0)
   
   bEdShouldSnap=true;
   bWorldGeometry=false
   bBumpEvenIfWorldGeometry=true
   bCollideActors=true
   bBlockActors=true
   
   DisappearTime = 3;
   DisappearDelay = 1;
   DisappearDuration = 5;
   Scale = 1.0;
   TickOptimize = TickOptimize_None
   
   RemoteRole=ROLE_SimulatedProxy
}

simulated event PostBeginPlay()
{
	Super.PostBeginPlay();
	
	CurrentDisappearDelay = DisappearDelay;
	CurrentDisappearDuration = DisappearDuration;
	
	SetTickIsDisabled(true);
}

simulated event Attach( Actor Other )
{
	 Super.Attach(Other);
    if (Activated) return;
    if (other.IsA('Hat_PawnGhost')) return;
	
	//Update these when activated in case of the values being modified during play
	CurrentDisappearDelay = DisappearDelay;
	CurrentDisappearDuration = DisappearDuration;
    
	Activated = true;
    Scale = 1.0;
	SetTickIsDisabled(false);
}

simulated event Tick(float d)
{
    Super.Tick(d);
    
    if (!Activated)
    {
        Scale += (1.0 - Scale)*FMin(d*5,1.0);
        Mesh.SetScale(Scale);
        return;
    }
    
    if (DisappearDelay > 0 && CurrentDisappearDelay > 0)
    {
        CurrentDisappearDelay -= d;
        if (CurrentDisappearDelay > 0)
        {
            Scale = 1.0 + Sin((DisappearDelay - CurrentDisappearDelay)*50)*0.05;
        }
    }
    if (CurrentDisappearDelay <= 0)
    {
        if (Scale > 0)
        {
            Scale -= d * (1.0/DisappearTime);
            if (Scale <= 0)
            {
                SetHidden(true);
            }
        }
        if (Scale <= 0)
        {
            CurrentDisappearDuration -= d;
            if (CurrentDisappearDuration <= 0)
            {
                Restart();
            }
        }
    }
    if (Scale > 0.0) Mesh.SetScale(Scale);
}

function Restart()
{
    SetHidden(false);
    Activated = false;
    CurrentDisappearDuration = DisappearDuration;
    CurrentDisappearDelay = DisappearDelay;
	Scale = 1.0;
	Mesh.SetScale(Scale);
	SetTickIsDisabled(true);
}