class Werti_SeqAct_GetDirectionVector extends SequenceAction;

var() Vector StartVector;
var() Vector EndVector;
var() Vector VectorResult;

event Activated()
{
	if (InputLinks[0].bHasImpulse)
	{
		VectorResult = EndVector - StartVector;
	}
}

defaultproperties
{
	ObjName="Get Direction Vector"
	ObjCategory="Math"
    HandlerName="OnGetDirectionVector"

	InputLinks(0)=(LinkDesc="In")

	VariableLinks.Empty
	VariableLinks(0)=(ExpectedType=class'SeqVar_Vector',LinkDesc="Start Vector",PropertyName=StartVector,bWriteable=false)
	VariableLinks(1)=(ExpectedType=class'SeqVar_Vector',LinkDesc="End Vector",PropertyName=EndVector,bWriteable=false)
	VariableLinks(2)=(ExpectedType=class'SeqVar_Vector',LinkDesc="Vector Result",PropertyName=VectorResult,bWriteable=true)
}
