/**
 * me (CatCube) :D 
 *
 * Actor that spawns collectibles in a perfect circle
 */

class Cat_CollectibleCircle extends Actor
	placeable;

//the collectible spawned
var() class<Hat_Collectible> Collectible;

//the amount of collectibles in the circle
var() int Amount;

//how large the radius of the circle is
var() float Radius;

var SpriteComponent SpriteComp;

function PostBeginPlay()
{
	local int i;

	Super.PostBeginPlay();
	
	for (i = 0; i < Amount; i++)
	{
		SpawnCollectible(i);
	}
}

function SpawnCollectible(int i)
{
	local Hat_Collectible c;
	local float StartRotation;
	local Rotator CurrentRotation;

	StartRotation = 65536/Amount;

	CurrentRotation.Yaw = StartRotation*i;

	c = Spawn(Collectible,,, (Location + Vector(CurrentRotation)*Radius) - c.Location, CurrentRotation,,true);
	c.SetBase(self);
	c.SetPhysics(PHYS_Interpolating);
}

defaultproperties
{
	Begin Object Class=SpriteComponent Name=Sprite 
		Sprite=Texture2D'EditorMaterials.TargetIcon'
		Scale=0.35
		HiddenGame=true
		AlwaysLoadOnClient=False
		AlwaysLoadOnServer=False
		SpriteCategoryName="TargetPoint"
	End Object
    Components.Add(Sprite);
	SpriteComp=Sprite;
	
	bStatic=false
	bNoDelete=true
	bMovable=true
	
	Radius = 150;
	Amount = 6;
	Collectible = class'Hat_Collectible_EnergyBit';
}