/**
 * Kismet action responsible for deleting all (or all prefixed) level bits from one or more levels.
 * Useful for resetting the """save file""" of a mod.
 */
class Drew_SeqAct_DeleteAllLevelBits extends SequenceAction;

/** Maps from which to delete level bits. If empty, the current map will be used. */
var() Array<string> Maps;

/** If not empty, only level bits with this prefix will be deleted. */
var() string WithPrefix<autocomment=true>;

event Activated()
{
	local Hat_SaveGame_Base SG;
	local int i;
	if (Maps.Length == 0)
	{
		Maps.AddItem(class'Hat_SaveBitHelper'.static.GetCorrectedMapFilename());
	}
	SG = class'Hat_SaveBitHelper'.static.GetSaveGame();
	for (i = 0; i < Maps.Length; i++)
	{
		if (WithPrefix != "")
			class'Hat_SaveBitHelper'.static.ResetLevelBitsByPrefix(WithPrefix, Maps[i], SG);
		else
			class'Hat_SaveBitHelper'.static.ResetLevelBitsForLevel(Maps[i], SG);
	}
}

defaultproperties
{
	ObjName = "Delete All Level Bits"
	ObjCategory = "Give me a custom category!"
	bCallHandler = false
	bSuppressAutoComment = false

	VariableLinks.Empty
}
