/**
 * Gets the integer that was saved in a level bit (likely with AbsoluteValue=True).
 */
class Drew_SeqAct_GetLevelBit extends SequenceAction;

/** Id to get the level bit from. */
var() String Id<autocomment=true>;

/* Map to get the level bit from. Leave blank to get from the currently loaded map. */
var() String Map;

var int Value;

event Activated()
{
	if (Id == "") return;
	Value = class'Hat_SaveBitHelper'.static.GetLevelBits(Id, Map);
}

defaultproperties
{
	ObjName = "Get Level Bit"
	ObjCategory = "Give me a custom category!"
	bCallHandler = false
	bSuppressAutoComment = false

	VariableLinks.Empty
	VariableLinks(0) = (ExpectedType=class'SeqVar_Int', LinkDesc="Value", PropertyName=Value, bWriteable=true)
}
