/**
 * Gets the integer that was saved in an act bit (likely with AbsoluteValue=True).
 */
class Drew_SeqAct_GetActBit extends SequenceAction;

/** Id to get the act bit from. */
var() String Id<autocomment=true>;

var int Value;

event Activated()
{
	if (Id == "") return;
	Value = class'Hat_SaveBitHelper'.static.GetActBits(Id);
}

defaultproperties
{
	ObjName = "Get Act Bit"
	ObjCategory = "Give me a custom category!"
	bCallHandler = false
	bSuppressAutoComment = false

	VariableLinks.Empty
	VariableLinks(0) = (ExpectedType=class'SeqVar_Int', LinkDesc="Value", PropertyName=Value, bWriteable=true)
}
