/**
 * Node that is meant to modify the contents of a Drew_KismetText.
 */
class Drew_SeqAct_ModifyKismetText extends SequenceAction;

var bool bOverride_Text;
var bool bOverride_TextColor;

var() string Text<EditCondition="bOverride_Text"|autocomment=true>;
var() Color TextColor<EditCondition="bOverride_TextColor">;

function ApplyOverrides(Hat_TextRenderComponent TextComp)
{
	if (TextComp == None) return;
	
	if (bOverride_Text)
		TextComp.Text = Text;
	if (bOverride_TextColor)
		TextComp.TextColor = TextColor;
	
	TextComp.ForceUpdate(false);
}

defaultproperties
{
	ObjName = "Modify Kismet Text"
	ObjCategory = "Give me a custom category!"
	// Despite what the comment Epic left might make you believe, it, in fact, does NOT
	// automatically generate the handler name, and you DO need to set this yourself :)
	HandlerName = "OnModifyKismetText"
	bSuppressAutoComment = false
	
	Text = ""
	TextColor = (R = 255, G = 255, B = 255, A = 255)
}
