/**
 * Custom note actor that can be modified using the Drew_SeqAct_ModifyKismetText node.
 */
class Drew_KismetText extends Actor
	placeable;

var() Hat_TextRenderComponent TextRenderComponent;

event OnModifyKismetText(Drew_SeqAct_ModifyKismetText Seq)
{
	Seq.ApplyOverrides(TextRenderComponent);
}

defaultproperties
{
	Begin Object Class=Hat_TextRenderComponent Name=TextRenderComponent0
		//this looks pretty well centered
		Translation = (Z = 18)
		TextLimit = 50
		Text = "Text"
		HiddenGame = false
	End Object
	TextRenderComponent = TextRenderComponent0;
	Components.Add(TextRenderComponent0)
	
	//Just as a means to select it
	Begin Object Class=SpriteComponent Name=Sprite
		Translation = (Z = -20)
		Scale = 0.5
		Sprite = Texture2D'EditorResources.S_Note'
		HiddenGame = True
		AlwaysLoadOnClient = False
		AlwaysLoadOnServer = False
		SpriteCategoryName = "Notes"
	End Object
	Components.Add(Sprite)
	Begin Object Class=ArrowComponent Name=Arrow
		Translation = (Z = -20)
		ArrowColor = (R=150,G=200,B=255)
		ArrowSize = 0.5
		bTreatAsASprite = True
		HiddenGame = true
		AlwaysLoadOnClient = False
		AlwaysLoadOnServer = False
		SpriteCategoryName = "Notes"
	End Object
	Components.Add(Arrow)
}
