/**
 * A node to modify the value of a GameMod config.
 * Based on SuperInkLink's Has Config Value script.
 */
class Drew_SeqAct_SaveConfigValue extends SequenceAction;

/* The gamemod class to modify the config for. Format: ModFolderName.GameModName */
var() string GamemodName;

/** Name of the config variable to modify. */
var() Name ConfigName;

/** New value to set the config to. */
var() int NewValue;

event Activated()
{
	local class<GameMod> GamemodClass;

	if (GamemodName != "")
		GamemodClass = class<GameMod>(class'Hat_ClassHelper'.static.ActorClassFromName(GamemodName));
	else
	{
		`broadcast("[" $ self $ "] ERROR - a GameMod name was not specified!");
		return;
	}

	if (GameModClass == None)
	{
		`broadcast("[" $ self $ "] ERROR - Could not find GameMod class " $ GamemodName);
		return;
	}

	if (GamemodClass.static.SaveConfigValue(GamemodClass, ConfigName, NewValue))
	{
		// Great, everything worked correctly!
		return;
	}
	else
	{
		`broadcast("[" $ self $ "] ERROR - failed to set config variable " $ PathName(GameModClass) $ ":" $ ConfigName $ " = " $ NewValue $ ". Does the variable exist?");
	}
}

defaultproperties
{
	ObjName = "Save Config Value"
	ObjCategory = "Give me a custom category!"
	bCallHandler = false

	VariableLinks.Empty
	VariableLinks(0) = (ExpectedType=class'SeqVar_Int', LinkDesc="New Value", PropertyName=NewValue)
}
