/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class SS_Platform_Base extends Actor
    abstract;
	
var(Particles) ParticleSystem ActivationParticle;
var(Particles) ParticleSystem DisappearParticle;
var(Sounds) SoundCue ActivationSound;
var(Sounds) SoundCue DisappearSound;

defaultproperties
{
	TickOptimize = TickOptimize_View;
	bNoEncroachCheck = true;
	
	RemoteRole=ROLE_SimulatedProxy
	
	ActivationParticle = None;
	DisappearParticle = None;
	ActivationSound = None;
	DisappearSound = None;

}

simulated event Attach( Actor Other )
{
}

// True to override jump functionality
simulated function bool JumpBoost(Actor other, out Vector v)
{
	return false;
}

simulated function bool CallInteractionEvent(Actor other)
{
    local int idx;
	local Hat_SeqEvent_OnInteraction hEvent;
    local bool s;
    
    s = false;

	// search for any events
	for (idx = 0; idx < GeneratedEvents.Length; idx++)
	{
		hEvent = Hat_SeqEvent_OnInteraction(GeneratedEvents[idx]);
		if (hEvent != None)
		{
			// notify that we have a interaction event
			if (hEvent.HandleInteraction(self, other))
            {
                s = true;
            }
		}
	}
    return s;
}

function Vector GetCenter()
{
	local Vector v;
	
	v = Location + vect(0,0,1)*40;
	return v;
}