/**
 * Copyright 1998-2014 Epic Games, Inc. All Rights Reserved.
 */
class Ink_SeqCond_HasNameInClass extends SequenceCondition;

var() bool RequireAll;
var() string RequiredName;

var Array<Actor> Targets;

event Activated()
{
	local int i;
	local bool IsTimmy;
	local Actor a;

	IsTimmy = RequiredName == "";
    
	if (!IsTimmy)
	{
		for (i = 0; i < Targets.Length; i++)
		{
			if (Controller(Targets[i]) != None)
				a = Controller(Targets[i]).Pawn;
			else
				a = Targets[i];

			if (a != None && InStr(string(a.class), RequiredName,, true) != INDEX_NONE)
			{
				IsTimmy = true;
				if (!RequireAll) 
					break;
			}
			else if (RequireAll)
			{
				IsTimmy = false;
				break;
			}
		}
	}

    OutputLinks[IsTimmy ? 0 : 1].bHasImpulse = true;
}

static function Print(string s)
{
    class'WorldInfo'.static.GetWorldInfo().Game.Broadcast(class'WorldInfo'.static.GetWorldInfo(), s);
}

defaultproperties
{
	ObjName="Has Name in Class (Template)"
	ObjCategory="Actor"
	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Targets",PropertyName=Targets)
	
	RequiredName = "Timmy";
}
