/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class Ink_SeqCond_HasModContract extends SequenceCondition;

var() string ContractClassName, ContractClassPackage;
var() bool ContractIsComplete;

event Activated()
{
	local class<Hat_SnatcherContract> ContractClass;

	ContractClass = class<Hat_SnatcherContract>(class'Hat_ClassHelper'.static.ClassFromName(ContractClassName, ContractClassPackage));
    OutputLinks[HasContract(ContractClass, ContractIsComplete) ? 0 : 1].bHasImpulse = true;
}

static function bool HasContract( class<Hat_SnatcherContract> Contract, optional bool CompletedOnly)
{
	local Hat_SaveGame SaveGame;

	if (Contract == None) return false;
	
	if (class<Hat_SnatcherContract_DeathWish>(Contract) != None)
		return class<Hat_SnatcherContract_DeathWish>(Contract).static.IsActive();
	
	SaveGame = Hat_SaveGame(`SaveManager.SaveData);
	if (SaveGame == None) return false;

	return	(
				(!CompletedOnly && SaveGame.SnatcherContracts.Find(Contract) != INDEX_NONE) ||
				(SaveGame.CompletedSnatcherContracts.Find(Contract) != INDEX_NONE) ||
				(SaveGame.TurnedInSnatcherContracts.Find(Contract) != INDEX_NONE)
			);
}


defaultproperties
{
	ObjName="Has Mod Contract"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")

	ContractClassPackage = "HatInTimeGameContent"
}