class Ink_Collectible_ModRemix_Base extends Hat_Collectible_Remix
	abstract;
    
var() Array<string> TargetModCueNames; //Refer to the defaults below.

var bool NeedsEdit; //This will reset once the game closes, but persist throughout. Basically so we don't have to iterate multiple times a session.

static function UpdateTargetCues()
{
	local Ink_Collectible_ModRemix_Base DefaultRemix;
	local SoundCue AddonCue;
	local string format;
	local int i;

	if (!default.NeedsEdit) return;

	format = default.class.GetPackageName() $ ".Default__" $ string(default.class);
	DefaultRemix = Ink_Collectible_ModRemix_Base(DynamicLoadObject(format, default.class, true));
	if (DefaultRemix != None)
	{
		for (i = 0; i < default.TargetModCueNames.Length; i++)
		{
			if (len(default.TargetModCueNames[i]) <= 0) continue;
			
			AddonCue = SoundCue(DynamicLoadObject(default.TargetModCueNames[i], class'SoundCue', true));
			
			if (AddonCue != None)
			{
				DefaultRemix.TargetSoundCues[i] = AddonCue;
				DefaultRemix.NeedsEdit = false;
			}
		}
	}
}

defaultproperties
{
	HUDIcon = None;

	SupportsRoulette=false;
	ShouldShowInBackpack=false;

	NeedsEdit = true;
}