class LK_SeqFlow_Foreach extends LK_SeqFlow_Loop;

var Array<Object> InList;
var int Index;
var Object OutObject;

public event Activated()
{
    Super.Activated();
    
    // Break / abort is prioritized
    if(InputLinks[BreakInputIdx].bHasImpulse)
    {
        ForceActivateOutput(CompletedOutputIdx);
    }
    else if(InputLinks[MainInputIdx].bHasImpulse)
    {
        if(InList.Length == 0)
        {
            ForceActivateOutput(CompletedOutputIdx);
            return;
        }

        PublishLinkedVariableValues();

        Index = 0;
        OutObject = InList[Index];

        PopulateLinkedVariableValues();

        ForceActivateOutput(LoopBodyIdx);
    }
    else if(InputLinks[InternalLoopInputIdx].bHasImpulse)
    {
        if(Index < InList.Length-1)
        {
            Index++;
            OutObject = InList[Index];

            PopulateLinkedVariableValues();

            ForceActivateOutput(LoopBodyIdx);
        }
        else
        {
            Index = 0;
            OutObject = None;

            PopulateLinkedVariableValues();

            ForceActivateOutput(CompletedOutputIdx);
        }
    }
}

defaultproperties
{
    ObjName = "Foreach Loop"
    VariableLinks.Empty;
    VariableLinks(1) = (LinkDesc="Index", ExpectedType=class'SeqVar_Int', bWriteable=true, PropertyName=Index, MaxVars=1, bHidden=true)
    VariableLinks(0) = (LinkDesc="List", ExpectedType=class'SeqVar_ObjectList', bWriteable=false, PropertyName=InList, MaxVars=1)
    VariableLinks(2) = (LinkDesc="Object", ExpectedType=class'SeqVar_Object',bWriteable=true, PropertyName=OutObject, MaxVars=1)
}