class LK_SeqFlow_For extends LK_SeqFlow_Loop;

var int Index;
var() int FirstIndex;
var() int LastIndex;

public event Activated()
{
    Super.Activated();
    
    // Break / abort is prioritized
    if(InputLinks[BreakInputIdx].bHasImpulse)
    {
        ForceActivateOutput(CompletedOutputIdx);
    }
    else if(InputLinks[MainInputIdx].bHasImpulse)
    {
        if(FirstIndex > LastIndex || LastIndex < FirstIndex || OutputLinks[0].Links.Length == 0)
        {
            ForceActivateOutput(CompletedOutputIdx);
            return;
        }

        Index = FirstIndex;

        PopulateLinkedVariableValues();

        ForceActivateOutput(LoopBodyIdx);
    }
    else if(InputLinks[InternalLoopInputIdx].bHasImpulse)
    {
        if(Index < LastIndex)
        {
            Index++;
            PopulateLinkedVariableValues();
            ForceActivateOutput(LoopBodyIdx);
        }
        else
        {
            ForceActivateOutput(CompletedOutputIdx);
        }
    }
}

defaultproperties
{
    ObjName = "For Loop"
    VariableLinks.Empty
    VariableLinks(0) = (LinkDesc="Index", ExpectedType=class'SeqVar_Int', bWriteable=true, PropertyName=Index, MaxVars=1)
    VariableLinks(1) = (LinkDesc="First Index", ExpectedType=class'SeqVar_Int', bWriteable=false, PropertyName=FirstIndex, bHidden=true)
    VariableLinks(2) = (LinkDesc="Last Index", ExpectedType=class'SeqVar_Int', bWriteable=false, PropertyName=LastIndex, bHidden=true)
}