class LK_SeqFlow_While extends LK_SeqFlow_Loop;

var() bool Condition;
var() int SafetyLimit; // 0 for no safety limit.
var int Counter;

public event Activated()
{
    Super.Activated();

    // break / abort is prioritized
    if(InputLinks[BreakInputIdx].bHasImpulse)
    {
        ForceActivateOutput(CompletedOutputIdx);
    }
    else if(InputLinks[MainInputIdx].bHasImpulse)
    {
        PublishLinkedVariableValues();

        if(!Condition)
        {
            ForceActivateOutput(CompletedOutputIdx);
            return;
        }

        Counter = 0;

        ForceActivateOutput(LoopBodyIdx);
    }
    else if(InputLinks[InternalLoopInputIdx].bHasImpulse)
    {
        PublishLinkedVariableValues();
        if((Counter < SafetyLimit || SafetyLimit == 0) && Condition)
        {
            Counter++;
            ForceActivateOutput(LoopBodyIdx);
        }
        else
        {
            ForceActivateOutput(CompletedOutputIdx);
        }
    }
}

defaultproperties
{
    ObjName = "While Loop"

    VariableLinks.Empty
    VariableLinks(0)=(LinkDesc="Condition",ExpectedType=class'SeqVar_Bool',bWriteable=false, PropertyName=Condition)
    SafetyLimit = 100;
}