class LK_SeqAct_CallFunction extends SequenceAction;

var() Name TargetFunctionName; // Target Function must be within this sequence and must exist.

var LK_SequenceFunction Func;

public event Activated()
{
    if(Func == None)
    {
        FindFunctionDefinition();

        if(Func == None)
        {
            ScriptLog("No Function with name \""$String(TargetFunctionName)$"\" could be found! Skipping.", true);
            ForceActivateOutput(0);
            return;
        }

        if(VariableLinks.Length != Func.FunctionParams.Length || Func.VariableLinks.Length != Func.FunctionParams.Length)
        {
            ScriptLog("Manual update required for \""$String(Func.FunctionName)$"\"! (Use Tools > Check Map For Errors) Skipping.");
            ForceActivateOutput(0);
            return;
        }
    }

    PublishLinkedVariableValues();

    Func.Execute(self);
}

public function OnFunctionCompleted(LK_SequenceFunction _Func)
{
    AcceptVars(_Func);
    ForceActivateOutput(0);
}

private function FindFunctionDefinition()
{
    local Array<SequenceObject> objs;
    local int i;
    GetWorldInfo().GetGameSequence().FindSeqObjectsByClass(class'LK_SequenceFunction', true, objs);

    for(i = 0; i < objs.Length; i++)
    {
        if(LK_SequenceFunction(objs[i]).FunctionName == TargetFunctionName)
        {
            Func = LK_SequenceFunction(objs[i]);
            break;
        }
    }
}

private function AcceptVars(LK_SequenceFunction Src)
{
    local int i;

    for(i = 0; i < VariableLinks.Length; i++)
    {
        if(Func.FunctionParams[i].bIsOutput) class'LK_SequenceFunction'.static.CopySeqVar(Src.VariableLinks[i].LinkedVariables[0], VariableLinks[i].LinkedVariables[0]);
    }

    PopulateLinkedVariableValues();
}

event CheckForErrors(out Array<string> ErrorMessages)
{
    FindFunctionDefinition();
    if(Func == None)
    {
        ErrorMessages.AddItem("Target function doesn't exist in sequence!");
        return;
    }

    class'LK_SequenceFunction'.static.UpdateVariableLinksFor(self, Func.FunctionParams, false);


    ObjName = "Call Function: "$String(TargetFunctionName);
}

defaultproperties
{
    ObjName = "Call Function"
    ObjCategory = "Functions"

    ObjColor = (R=138, G=29, B=29, A=255);

    VariableLinks.Empty;

    bAutoActivateOutputLinks = false; // important!

    ObjComment = "A bunch of things are handled automatically when you use Tools > Check Map For Errors."
}