class SS_StatusEffect_SlowingCold extends Hat_StatusEffect;


defaultproperties
{
    Duration = -1;
}

function OnAdded(Actor a)
{
	Super.OnAdded(a);
}

simulated function OnRemoved(Actor a)
{
	Super.OnRemoved(a);
}

function bool Update(float d)
{

	local Hat_Player plyr;
	
	plyr = Hat_Player(Owner);
	
	if (!Super.Update(d)) return false;	
	
	
	
	if(plyr != None)
	{
		if (plyr.HasStatusEffect(class'Hat_StatusEffect_BadgeSprint', true) || plyr.HasStatusEffect(class'Hat_StatusEffect_BadgeScooter', true))
			{
				plyr.StatusEffects.Sort(Sort_MoveStatusToEnd);
			}
	}
	return true;
}

delegate int Sort_MoveStatusToEnd(Hat_StatusEffect A, Hat_StatusEffect B)
{
    if (A.IsA(Class.Name)) return -1; //Swap
    return 0; //Don't Swap
}

function float GetSpeedMultiplier()
{
	return 0.7f;
}