class HatTD_HUDElementLocationBanner_ValleyOfTitans extends Hat_HUDElement;

var Name LocationName;
var string LocalizedLocationName;
var Array<Surface> Icons;
var float BigTransitionIn;
var float FadeIn;
var Surface TimePieceIcon[3];
var Surface MetroTicketIcon;
var Surface EscapeIcon;
var SoundCue AppearSound;
var bool IsInFinaleEscape;

defaultproperties
{
	TimePieceIcon(0) = Texture2D'HatInTime_Hud.Textures.Collectibles.collectible_timepiece'
	TimePieceIcon(1) = Texture2D'HatInTime_Hud_LocationBanner2.Textures.TimePiece_Outline'
	TimePieceIcon(2) = Texture2D'HatInTime_Hud_LocationBanner2.Textures.TimePiece_Circle_Outline'
	MetroTicketIcon = Texture2D'HatInTime_Hud_LocationBanner2.Textures.Ticket_Icons_Outline'
	EscapeIcon = Texture2D'HatInTime_Levels_Metro_M.Textures.EscapeTunnel_Icon'
	AppearSound = SoundCue'HatinTime_SFX_Metro.SoundCues.MetroLocationBannerAppear'
}

function OnOpenHUD(HUD H, optional string command)
{
	Super.OnOpenHUD(H, command);
	
	if (command == "nointro")
	{
		FadeIn = 99;
		BigTransitionIn = 99;
	}
	
	else
	{
	    SetNewLocationName(name(command));
		FadeIn = 0;
		BigTransitionIn = 0;
		if (IsEnabled() && !H.PlayerOwner.bCinematicMode)
		{
			PlayOwnerSound(H, AppearSound);
		}
	}
	
	RefreshAll(H);
}

function bool IsFinaleEscape(Name InLocationName)
{
	return InLocationName == 'Metro_Escape_Location';
}

function SetNewLocationName(Name Locale)
{
 LocationName = Locale;
}

function Name GetNewLocationName()
{
	local Name NewLocationName;
	
	NewLocationName = LocationName;
	
	return NewLocationName;
}

function OnCheckpoint()
{
	ConditionalOpen(false);
}

function ConditionalOpenForHUD(Hat_HUD MyHUD, bool NoIntro)
{
	local HatTD_HUDElementLocationBanner_ValleyOfTitans HUDElement;
	local Name NewLocationName;
	
	NewLocationName = GetNewLocationName();
	if (NewLocationName == '') return;
	
	HUDElement = HatTD_HUDElementLocationBanner_ValleyOfTitans(MyHUD.GetHUD(default.Class));
	if (HUDElement == None)
	{
		MyHUD.OpenHUD(default.Class, NoIntro ? "nointro" : "");
		return;
	}
	if (NewLocationName == HUDElement.LocationName) return;
	
	if (NoIntro)
		HUDElement.RefreshAll(MyHUD);
	else
		HUDElement.OnOpenHUD(MyHUD, "");
}


function ConditionalOpen(bool NoIntro)
{
	local int i;
	local HUD MyHUD;
	local Name NewLocationName;

	NewLocationName = GetNewLocationName();
	if (NewLocationName == '') return;
	
	for (i = 0; i < class'Engine'.static.GetEngine().GamePlayers.Length; i++)
	{
		MyHUD = class'Engine'.static.GetEngine().GamePlayers[i].Actor.MyHUD;
		if (MyHUD == None) continue;
		ConditionalOpenForHUD(Hat_HUD(MyHUD), NoIntro);
	}
}

function RefreshAll(HUD H)
{
	LocationName = GetNewLocationName();
	IsInFinaleEscape = IsFinaleEscape(LocationName);

	LocalizedLocationName = LocationName != '' ? class'Hat_Localizer'.static.GetGame("levels", string(LocationName)) : "???";
	
	RefreshIcons(H, LocationName);
}

function bool IsManhole(Hat_ChapterActInfo cai)
{
	local Hat_ChallengeRoomManhole_Base manhole;
	foreach class'WorldInfo'.static.GetWorldInfo().DynamicActors(class'Hat_ChallengeRoomManhole_Base', manhole)
	{
		if (manhole.ChapterActInfo == cai) return true;
	}
	return false;
}

function RefreshIcons(HUD H, Name InLocationName)
{
	local Hat_ChapterInfo ci;
	local int i, NumClaimedTP, NumUnclaimedTP, NumUnclaimedManholeTP;
	local Array<class<object>> MetroTickets;
	local Hat_Loadout MyLoadout;
	
	Icons.Length = 0;
	
	if (IsInFinaleEscape)
	{
		Icons.AddItem(EscapeIcon);
		return;
	}
	
	ci = `GameManager.GetChapterInfo();
	if (ci != None && InLocationName != '')
	{
		ci.ConditionalUpdateActList();
		for (i = 0; i < ci.ChapterActInfo.Length; i++)
		{
			if (ci.ChapterActInfo[i].Hourglass == "") continue;
			if (ci.ChapterActInfo[i].InDevelopment) continue;
			if (ci.ChapterActInfo[i].LocationName != InLocationName) continue;
			
			if (`GameManager.HasTimePiece(ci.ChapterActInfo[i].Hourglass)) NumClaimedTP++;
			else if (IsManhole(ci.ChapterActInfo[i])) NumUnclaimedManholeTP++;
			else NumUnclaimedTP++;
		}
		
		for (i = 0; i < NumClaimedTP; i++) Icons.AddItem(TimePieceIcon[0]);
		for (i = 0; i < NumUnclaimedTP; i++) Icons.AddItem(TimePieceIcon[1]);
		for (i = 0; i < NumUnclaimedManholeTP; i++) Icons.AddItem(TimePieceIcon[2]);
		
		MetroTickets = class'Hat_ClassHelper'.static.GetAllScriptClasses("Hat_Collectible_MetroTicket_Base");
		MyLoadout = Hat_PlayerController(H.PlayerOwner).GetLoadout();
		for (i = 0; i < MetroTickets.Length; i++)
		{
			if (class<Hat_Collectible_MetroTicket_Base>(MetroTickets[i]).default.LocationName != InLocationName) continue;
			Icons.AddItem((MyLoadout != None && MyLoadout.HasCollectible(MetroTickets[i], 1)) ? class<Hat_Collectible_MetroTicket_Base>(MetroTickets[i]).static.GetHUDIcon() : MetroTicketIcon);
		}
	}
}

function bool Tick(HUD H, float delta)
{
	local Hat_PlayerController PC;
	if (!Super.Tick(H, delta)) return false;
	
	PC = Hat_PlayerController(H.PlayerOwner);
	if ((PC != None && PC.IsTalking()) || H.PlayerOwner.bCinematicMode)
		FadeIn = FMax(FMin(FadeIn,1.3)-Delta/0.5f,0.f);
	else
		FadeIn = FMin(FadeIn+Delta/1.5f,2.f);
	
	BigTransitionIn = FMin(BigTransitionIn+Delta/1.5f,2.f);

	return true;
}
function bool Render(HUD H)
{
	local float Padding;
	local float PosX;
	local float PosY;
	local float SizeX;
	local float SizeY;
	local float TransitionAlpha;
	
	if (!Super.Render(H)) return false;
	if (FadeIn <= 0) return false;
	
	Padding = FMin(H.Canvas.ClipX,H.Canvas.ClipY)*0.02f;
	PosX = H.Canvas.ClipX*0.9125-Padding;
	`if(`isdefined(WITH_GHOSTPARTY))
	if(class'Hat_HUDElementPlayerList'.static.IsOpenAndVisible(H))
		PosX -= H.Canvas.ClipX*0.15;
	`endif
	
	PosY = H.Canvas.ClipY*0.0625+Padding;
	SizeX = H.Canvas.ClipX*0.175;
	SizeY = H.Canvas.ClipY*0.125;
	TransitionAlpha = FClamp((BigTransitionIn-1.5f)/0.4f,0,1);
	TransitionAlpha = class'Hat_Math'.static.InterpolationEaseInEaseOutJonas(0,1,TransitionAlpha);
	
	PosX = Lerp(H.Canvas.ClipX/2, PosX, TransitionAlpha);
	PosY = Lerp(H.Canvas.ClipY*0.22, PosY, TransitionAlpha);
	SizeX = Lerp(SizeX*2.5, SizeX, TransitionAlpha);
	SizeY = Lerp(SizeY*2.5, SizeY, TransitionAlpha);

	RenderBanner(H, PosX, PosY, SizeX, SizeY);
	
    return true;
}

function RenderBanner(HUD H, float PosX, float PosY, float Width, float Height)
{
	RenderBanner_Name(H, PosX, PosY-Height*0.5f+Height*0.2, Width, Height*0.4);
	RenderBanner_Collectibles(H, PosX, PosY+Height*0.5f-Height*0.3f, Width, Height*0.6f);
}


function RenderBanner_Name(HUD H, float PosX, float PosY, float Width, float Height)
{
	local float DividerPosY, DividerHeight, DividerWidth;
	local float TextPosY;
	//H.Canvas.SetDrawColor(255,0,0,64);
	//DrawCenter(H, PosX, PosY, Width, Height, H.Canvas.DefaultTexture);
	
	DividerPosY = PosY+Height*0.5f - Height*0.08f*0.5f;
	DividerHeight = Height*0.08f;
	
	H.Canvas.SetDrawColor(255,255,255,255);
	H.Canvas.Font = class'Hat_FontInfo'.static.GetDefaultFont(LocalizedLocationName);
	
	if (FadeIn < 1.f) H.Canvas.PushMaskRegion(0, 0, H.Canvas.ClipX, DividerPosY-Height*0.1f);
	TextPosY = PosY - Height*0.1f;
	TextPosY += ((1-FClamp((FadeIn-0.0f)/0.3f,0,1))**2)*Height*0.9f;
	DrawBorderedText(H.Canvas, LocalizedLocationName, PosX, TextPosY, Width*0.0018f, true, TextAlign_Center, 1,,,, BigTransitionIn >= 2.f ? 0.5f : 1.f);
	if (FadeIn < 1.f) H.Canvas.PopMaskRegion();
	
	// Divider
	DividerWidth = Width*(1-(1-FMin(FadeIn/0.3f,1))**2);
	H.Canvas.SetDrawColor(0,0,0,255);
	DrawCenter(H, PosX+Width*0.0075f, DividerPosY+Width*0.015f, DividerWidth, DividerHeight, H.Canvas.DefaultTexture);
	
	H.Canvas.SetDrawColor(0,0,0,255);
	DrawCenter(H, PosX, DividerPosY, DividerWidth+Width*0.015f, DividerHeight+Width*0.015f, H.Canvas.DefaultTexture);
	
	H.Canvas.SetDrawColor(255,255,255,255);
	DrawCenter(H, PosX, DividerPosY, DividerWidth, DividerHeight, H.Canvas.DefaultTexture);
}

function RenderBanner_Collectibles(HUD H, float PosX, float PosY, float Width, float Height)
{
	local int num, i;
	local float IconSize, IconSpacing, MyPosX, MyIconSize;
	//H.Canvas.SetDrawColor(0,255,0,64);
	//DrawCenter(H, PosX, PosY, Width, Height, H.Canvas.DefaultTexture);
	H.Canvas.SetDrawColor(255,255,255,255);
	
	IconSize = Height*0.75f;
	IconSpacing = IconSize*1.2f;
	
	num = Icons.Length;
	for (i = 0; i < num; i++)
	{
		MyIconSize = IconSize*class'Hat_Math'.static.InterpolationOvershoot(0, 1, FClamp((FadeIn-0.5f-i*0.15f)/0.2f,0,1));
		if (MyIconSize <= 0) continue;
		MyPosX = PosX + ((num-1)*-0.5f + i)*IconSpacing;
		DrawCenter(H, MyPosX, PosY, MyIconSize, MyIconSize, Icons[i]);
	}
}


event OnLanguageChange()
{
	RefreshAll(class'Hat_HUD'.static.GetPlayer1HUD());
}