/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class mcu8_NPC_Mobster_FallOffDocks extends mcu8_NPC_Mobster
    placeable;
	
var() Name KickedOffAnimation;
var() float ForwardVelocity;
var() float UpwardVelocity;
var(Particles) ParticleSystemComponent HitMangaZoomParticle;
var(Particles) ParticleSystem DeathExplosionParticle;
var(Particles) ParticleSystem DeathMangaZoomParticle;
var(Sounds) SoundCue HitSound;
var(Sounds) SoundCue DeathSound;
var(Sounds) SoundCue FallSounds[3];
var transient bool IsKickedOff;
var() bool KnockAllOffAchievement;

var() float FallTime;
var() bool FallDeathExplosion;
	
defaultproperties
{
	Begin Object Class=AnimNodeSequence Name=AnimNodeSeq1
		AnimSeqName = "Mafia_sit_dock";
		bLooping = true
		bPlaying = true
	End Object

	Begin Object Name=SkeletalMeshComponent0
		AnimSets(0)=AnimSet'HatinTime_Characters_Mafia.AnimSets.MafiaGreg_Anims_Docks'
		Animations=AnimNodeSeq1
	End Object
	
    Begin Object Class=ParticleSystemComponent Name=MangaZoomParticle0 
        Template =  ParticleSystem'HatInTime_PlayerAssets.Particles.mangazoom_damage'
        bAutoActivate = false;
		AbsoluteTranslation=true
    End Object
    Components.Add(MangaZoomParticle0);
    HitMangaZoomParticle = MangaZoomParticle0;
	
	Begin Object Name=CollisionCylinder
		bAlwaysRenderIfSelected=true
	End Object
	
	bBlockActors = false;
	
	KickedOffAnimation = "Mafia_fall_dock";
	ForwardVelocity = 150;
	UpwardVelocity = 600;
	FallTime = 5;
	HitSound = SoundCue'HatInTime_Weapons.SoundCues.PunchHit'
	DeathExplosionParticle = ParticleSystem'HatInTime_PlayerAssets.Particles.CombatEffects.MonsterCloudExplosion_Mesh';
	DeathMangaZoomParticle = ParticleSystem'HatInTime_PlayerAssets.Particles.mangazoom_death';
	DeathSound = SoundCue'HatInTime_PlayerAssets.SoundCues.enemy_explosion';
	FallSounds(0) = SoundCue'HatinTime_SFX_Player3.SoundCues.MafiaTown_MafiaFallDown_Short'
	FallSounds(1) = SoundCue'HatinTime_SFX_Player3.SoundCues.MafiaTown_MafiaFallDown_Medium'
	FallSounds(2) = SoundCue'HatinTime_SFX_Player3.SoundCues.MafiaTown_MafiaFallDown_Long'
}

event Touch(Actor Other, PrimitiveComponent OtherComp, Object.Vector HitLocation, Object.Vector HitNormal)
{
	local Hat_WaterVolume v;
	local Vector Loc;
	if (Other.IsA('Pawn') && Pawn(Other).IsPlayerPawn() && !IsKickedOff)
	{
		HitLocation = VLerp(Other.Location, Location, 0.5f);
		KickOffEffects(HitLocation);
		OnKickedOff(Other);
	}
	else if (IsKickedOff && Other.IsA('Hat_WaterVolume'))
	{
		v = Hat_WaterVolume(Other);
		if (v.EntrySoundDive != None)
			PlaySound(v.EntrySoundDive);
		if (v.EntrySound != None)
			PlaySound(v.EntrySound);
		Loc = Location + vect(0,0,-70);
		if (v.EntryParticleDive != None)
			Worldinfo.MyEmitterPool.SpawnEmitter(v.EntryParticleDive, v.EntryParticleDiveParentToActor ? (Loc + vect(0,0,-100)) : Loc);
		if (v.EntryParticleSurface != None)
			Worldinfo.MyEmitterPool.SpawnEmitter(v.EntryParticleSurface, Loc);
	}
	Super.Touch(Other, OtherComp, HitLocation, HitNormal);
}

function OnKickedOff(optional Actor Inflictor)
{
	local mcu8_NPC_Mobster_FallOffDocks mfod;
	local bool AnyNotKickedOffYet;
	local Hat_PlayerController PC;
	//SetCollision(false);
	class'Hat_SeqEvent_OnInteraction'.static.CallInteractionEvent(self, Inflictor, "OnFallOff");

	SkeletalMeshComponent.PlayAnim(KickedOffAnimation, , false, false);
	SetPhysics(Phys_Falling);
	Velocity = Vector(Rotation)*ForwardVelocity + vect(0,0,1)*UpwardVelocity;
	class'Hat_PawnCombat'.static.ShakeNearbyCameras_Static(200, 1024, 12, 0.4, Location, self);
	IsKickedOff = true;
	PlaySound(FallSounds[(FallTime >= 4) ? 2 : ((FallTime >= 1.4) ? 1 : 0)]);
	
	SetTimer(FallTime, false, NameOf(PostKickedOff));
	
	if (KnockAllOffAchievement)
	{
		AnyNotKickedOffYet = false;
		foreach DynamicActors(class'mcu8_NPC_Mobster_FallOffDocks', mfod)
		{
			if (mfod == self) continue;
			if (!mfod.KnockAllOffAchievement) continue;
			if (mfod.bDeleteMe) continue;
			if (mfod.IsKickedOff) continue;
			AnyNotKickedOffYet = true;
			break;
		}
		if (!AnyNotKickedOffYet && Inflictor != None && Inflictor.IsA('Pawn'))
		{
			PC = Hat_PlayerController(Pawn(Inflictor).Controller);
			if (PC != None)
			{
				PC.UnlockAchievement(26);
			}
		}
	}
	
	`if(`isdefined(WITH_GHOSTPARTY))
	if (Inflictor != None && Inflictor.IsA('Hat_Player'))
		class'Hat_GhostPartyPlayerBase'.static.SendSingleStateLevelObject(Hat_Player(Inflictor).GetPlayerIndex(), self);
	`endif
}

`if(`isdefined(WITH_GHOSTPARTY))
event OnGhostPartyStateChange(Actor Sender, int NewState)
{
	local Vector HitLocation;
	if (IsKickedOff) return;
	HitLocation = VLerp(Sender.Location, Location, 0.5f);
	KickOffEffects(HitLocation);
	OnKickedOff(Sender);
}
`endif

function KickOffEffects(Vector HitLocation)
{
	local ParticleSystemComponent p;
	Spawn(class'Hat_ExplosionLight_EnemyImpact',,, HitLocation);
	Spawn(class'Hat_DynamicRadialBlurActor_EnemyImpact',,, HitLocation);
	if (HitSound != None) PlaySound(HitSound);
	if (Worldinfo.MyEmitterPool != None)
	{
		p = Worldinfo.MyEmitterPool.SpawnEmitter(class'Hat_DamageType'.default.ImpactParticle, HitLocation);
		if (p != None)
			p.SetDepthPriorityGroup(SDPG_Foreground);
	}
	HitMangaZoomParticle.SetTranslation(Location);
	HitMangaZoomParticle.SetActive(true);
}

simulated event TakeDamage(int Damage, Controller InstigatedBy, vector HitLocation, vector Momentum, class<DamageType> DamageType, optional TraceHitInfo HitInfo, optional Actor DamageCauser)
{
	if (IsKickedOff) return;
	KickOffEffects(HitLocation);
	OnKickedOff(InstigatedBy != None ? InstigatedBy.Pawn : None);
}

function PostKickedOff()
{
	class'Hat_SeqEvent_OnInteraction'.static.CallInteractionEvent(self, None, "PostFallOff");

	if (FallDeathExplosion)
	{
		Spawn(class'Hat_ExplosionLight_EnemyDeath',,, Location);
		Spawn(class'Hat_DynamicRadialBlurActor_EnemyDeath',,, Location);
		if (DeathExplosionParticle != None)
			Worldinfo.MyEmitterPool.SpawnEmitter(DeathExplosionParticle, Location);
		if (DeathMangaZoomParticle != None && !WorldInfo.IsConsoleBuild())
			Worldinfo.MyEmitterPool.SpawnEmitter(DeathMangaZoomParticle, Location);
		if (DeathSound != None)
			PlaySound(DeathSound);
		class'Hat_PawnCombat'.static.ShakeNearbyCameras_Static(200, 1024, 60, 0.4, Location, self);
	}
	
	Destroy();
}

simulated function bool CanBeInteractedWith(Actor hOther)
{
    return false;
}
