/*
 *  Garbage code by m_cu8
 */
class sb64_Hazard_CatTrain_Dweller extends sb64_Hazard_CatTrain;

var(Collisions) bool InvertCollisionWhenDeactivated;

event editoronly GetCustomEditorCommands(out Array<ActorCustomEditorCommand> Result)
{
	local ActorCustomEditorCommand Item;
	
	Item.Text = "Inverted Dweller Mesh";
	Item.Command = 'InvertDwellerMesh';
	Item.CurrentValue = bBlockActors ? 0 : 1;
	Result.AddItem(Item);
}

event editoronly OnEditorCustomCommand(Name Command, int Index)
{
	if (Command == 'InvertDwellerMesh')
	{
		SetTrainColor();
	}
}

function SetTrainColor()
{
	if (bBlockActors)
	{
		SetCollision(false,false);
		TrainMesh.SetMaterial(0, MaterialInstanceConstant'hatintime_dwellerobjects.Materials.DwllerObject_Phong_Inverse');    
	}
	else
	{
		SetCollision(true,true);
		TrainMesh.SetMaterial(0, Material'hatintime_dwellerobjects.Materials.DwllerObject_Phong');
	}
}

simulated event PostBeginPlay()
{
    isDweller = true;
	InvertCollisionWhenDeactivated_Internal = InvertCollisionWhenDeactivated;
	SetTrainColor();
    Super.PostBeginPlay();
	
	InitialBlockActors = bBlockActors;
	// if (InvertCollisionWhenDeactivated)
	// 	SetCollisionType(COLLIDE_BlockAll);
	
	InitMaterialInstancesMesh(TrainMesh);
	SetMaterialFloatMesh(TrainMesh, 'Editor', 0);
}

/* MATERIALS */
function InitMaterialInstancesMesh(Meshcomponent m)
{
    local int i;
    local MaterialInstanceConstant Mat;
    for (i = 0; i < m.GetNumElements(); i++)
    {
        if (m.GetMaterial(i) == None) continue;
        Mat = m.CreateAndSetMaterialInstanceConstant(i);
        m.SetMaterial(i, Mat);
    }
}


/* MATERIAL FUNCTIONS */

function SetMaterialVectorMesh(MeshComponent m, Name n, Vector c)
{
    local int i;
    local MaterialInstance Mat; 
	local LinearColor v;
	
	v.R = c.X;
	v.G = c.Y;
	v.B = c.Z;
	v.A = 1;
	
	if (m == None) return;
    for (i = 0; i < m.GetNumElements(); i++)
    {
        Mat = MaterialInstance(m.GetMaterial(i));
        if (Mat != None)
        {
            Mat.SetVectorParameterValue(n, v);
        }
    }
}

function SetMaterialFloatMesh(MeshComponent m, Name n, float f)
{
    local int i;
    local MaterialInstance Mat; 
	
	if (m == None) return;
    for (i = 0; i < m.GetNumElements(); i++)
    {
        Mat = MaterialInstance(m.GetMaterial(i));
        if (Mat != None)
        {
            Mat.SetScalarParameterValue(n, f);
        }
    }
}

function SetTransitionEffectVectorMesh(MeshComponent m, Name n, Vector start, Vector end, float time)
{
    local int i;
    local InterpCurveVector Curve;
    local MaterialInstanceTimeVarying Mat;
    
    Curve = GenerateCurveVector(start, end, time);
    
    for (i = 0; i < m.GetNumElements(); i++)
    {
        Mat = MaterialInstanceTimeVarying(m.GetMaterial(i));
        if (Mat != None)
        {
            Mat.SetVectorCurveParameterValue(n, Curve);
            Mat.SetVectorStartTime(n, 0.0);
        }
    }
}

function SetTransitionEffectFloatMesh(MeshComponent m, Name n, float start, float end, float time)
{
    local int i;
    local InterpCurveFloat Curve;
    local MaterialInstanceTimeVarying Mat;
    
    Curve = GenerateCurveFloat(start, end, time);
    
    for (i = 0; i < m.GetNumElements(); i++)
    {
        Mat = MaterialInstanceTimeVarying(m.GetMaterial(i));
        if (Mat != None)
        {
            Mat.SetScalarCurveParameterValue(n, Curve);
            Mat.SetScalarStartTime(n, 0.0);
        }
    }
}

function InterpCurveFloat GenerateCurveFloat(float start, float end, float time)
{
    local InterpCurveFloat Curve;
    local InterpCurvePointFloat Point;
    
    Point.InVal = 0.0;
    Point.OutVal = start;
    Curve.Points.AddItem(Point);
    
    Point.InVal = time;
    Point.OutVal = end;
    Curve.Points.AddItem(Point);
    
    return Curve;
}

function InterpCurveVector GenerateCurveVector(Vector start, Vector end, float time)
{
    local InterpCurveVector Curve;
    local InterpCurvePointVector Point;
	
    Point.InVal = 0.0;
    Point.OutVal = start;
    Curve.Points.AddItem(Point);
    
    Point.InVal = time;
    Point.OutVal = end;
    Curve.Points.AddItem(Point);
    
    return Curve;
}

defaultproperties
{
    Begin Object Name=Model1
        Materials(0)=Material'HatInTime_Levels_Metro_A.GhostTrain'
        Materials(1)=Material'HatInTime_Characters.Materials.Invisible'
	End Object

	InvertCollisionWhenDeactivated = true;
	isDweller = true;
}