class mcu8_KismetOPMain extends GameMod;
// WARNING!!! IF YOU HAVE YOUR OWN GAMEMOD CLASS 
// YOU NEED TO COPY EVERYTHING BELOW TO YOUR OWN GAMEMOD CLASS
// AND REPLACE EVERY "mcu8_KismetOPMain" INSTANCE WITH YOUR OWN
// CLASS NAME BY USING THE TEXT EDITOR!!!

event OnOnlinePartyCommand(string Command, Name CommandChannel, Hat_GhostPartyPlayerStateBase Sender)
{
    CauseEvent(CommandChannel, Command, Sender);
}

function CauseEvent(Name EventChannel, String EventName, Hat_GhostPartyPlayerStateBase Sender)
{
	local array<SequenceObject> AllOPEvents;
	local mcu8_SeqEvent_OnlinePartyCommandReceived OPEvt;
	local Sequence GameSeq;
	local int Idx;
	local bool bFoundEvt;
	// Get the gameplay sequence.
	GameSeq = class'WorldInfo'.static.GetWorldInfo().GetGameSequence();
	if ( (GameSeq != None) && (EventName != "") )
	{
		// Find all mcu8_SeqEvent_OnlinePartyCommandReceived objects anywhere.
		GameSeq.FindSeqObjectsByClass(class'mcu8_SeqEvent_OnlinePartyCommandReceived', TRUE, AllOPEvents);

		// Iterate over them, seeing if the name is the one we typed in.
		for( Idx=0; Idx < AllOPEvents.Length; Idx++ )
		{
			OPEvt = mcu8_SeqEvent_OnlinePartyCommandReceived(AllOPEvents[Idx]);
			if (OPEvt != None && EventChannel == OPEvt.OnlinePartyChannelName  && EventName ~= OPEvt.OnlinePartyCommandName)
			{
				bFoundEvt = TRUE;
				`broadcast("Activate event " $ EventName $ " in channel " $ EventChannel);
				OPEvt.CheckActivate(Sender.GhostActor, Sender.GhostActor);
			}
		}
	}
	if (!bFoundEvt)
	{
		`broadcast("Event not found!!!");
	}
}

static function mcu8_KismetOPMain GetMod()
{
    return mcu8_KismetOPMain(GetModByClass(class'mcu8_KismetOPMain'));
}

static function GameMod GetModByClass(class<GameMod> mod)
{
	local Actor lMod;
    local WorldInfo wi;
    wi = class'WorldInfo'.static.GetWorldInfo();
    if (wi != None)
        foreach wi.AllActors(mod, lMod)
            return GameMod(lMod);
}