/**
 * Copyright 1998-2021 Epic Games, Inc. All Rights Reserved.
 */
class Ink_SeqAct_DeathWishBonusState extends SequenceAction;

//What DW specifically you target.
var() class<Hat_SnatcherContract_DeathWish> DeathWishClass;
//The index of the bonus you want. Remember, main objective is zero!
var() int BonusIndex;
//Affects ALL non-failed objectives. Ignores failed objectives unless you have ForceClear checked.
var() bool AffectAllObjectives;
//Forcibly unlock a bonus, no matter if it's failed or not. Tends to not display HUD, so usually just use as a failsafe.
var() bool ForceClear;

event Activated()
{
	local int i;

	if (DeathWishClass == None) return;
	if (!DeathWishClass.static.IsActive()) return;
	if (BonusIndex < 0 && !AffectAllObjectives) return;

	//Bonus completion
	if (InputLinks[0].bHasImpulse)
    {
		if (AffectAllObjectives)
		{
			for (i = 0; i < DeathWishClass.default.Objectives.Length; i++)
			{
				if (!ForceClear)
					DeathWishClass.static.TriggerObjective(i);
				else
					DeathWishClass.static.ForceUnlockObjective(i);
			}
		}
		else
		{
			if (!ForceClear)
				DeathWishClass.static.TriggerObjective(BonusIndex);
			else
				DeathWishClass.static.ForceUnlockObjective(BonusIndex);
		}
	}
	if (InputLinks[1].bHasImpulse)
    {
		if (AffectAllObjectives)
		{
			for (i = 0; i < DeathWishClass.default.Objectives.Length; i++)
			{
				DeathWishClass.static.SetObjectiveFailed(i, true);
			}
		}
		else
		{
			DeathWishClass.static.SetObjectiveFailed(BonusIndex, true);
		}
	}
	if (InputLinks[2].bHasImpulse)
    {
		if (AffectAllObjectives)
		{
			for (i = 0; i < DeathWishClass.default.Objectives.Length; i++)
			{
				DeathWishClass.static.SetObjectiveFailed(i, false);
			}
		}
		else
		{
			DeathWishClass.static.SetObjectiveFailed(BonusIndex, false);
		}
	}
	if (InputLinks[3].bHasImpulse)
    {
		if (AffectAllObjectives)
		{
			for (i = 0; i < DeathWishClass.default.Objectives.Length; i++)
			{
				DeathWishClass.static.ResetObjectiveProgress(i);
			}
		}
		else
		{
			DeathWishClass.static.ResetObjectiveProgress(BonusIndex);
		}
	}
}

static function Print(string s)
{
    class'WorldInfo'.static.GetWorldInfo().Game.Broadcast(class'WorldInfo'.static.GetWorldInfo(), s);
}

defaultproperties
{
	ObjName="Toggle Death Wish Bonus"
	ObjCategory="Toggle"
	InputLinks(0)=(LinkDesc="Complete Bonus")
	InputLinks(1)=(LinkDesc="Fail Bonus")
	InputLinks(2)=(LinkDesc="Unfail Bonus")
	InputLinks(3)=(LinkDesc="Reset Progress")
}
