class Cat_SeqCond_IsPhys extends SequenceCondition;

var Actor Target;
var() Actor.EPhysics WhichPhysics;

event Activated()
{
	local bool IsPhys;
	local Pawn P;
	local Hat_PlayerController PC;

	PC = Hat_PlayerController(Target); // cast
	P = (PC != None ? PC.Pawn : None); // If PC exists, then get the pawn, otherwise, pawn is None
	
	if (!P.IsA('Hat_Player')) return;
	if (P.Physics == WhichPhysics) 
	{
		IsPhys = true;
	}

    OutputLinks[IsPhys ? 0 : 1].bHasImpulse = true;
}

defaultproperties
{
	ObjName="Is Phys"
	ObjCategory="Pawn"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target,MinVars=1,MaxVars=1)
	
	WhichPhysics = PHYS_None
}