class Cat_SeqCond_HasBadgeEquipped extends SequenceCondition;

var Actor Target;
var() class<Hat_Ability_Automatic> WhichBadge;

event Activated()
{
	local bool BadgeEquipped;
	local Hat_PlayerController PC;

	PC = Hat_PlayerController(Target); // cast
	
	if (PC.GetLoadout().LoadoutHasBadge(WhichBadge) != INDEX_NONE)
	{
		BadgeEquipped = true;
	}

    OutputLinks[BadgeEquipped ? 0 : 1].bHasImpulse = true;
}

defaultproperties
{
	ObjName="Has Badge Equipped"
	ObjCategory="Pawn"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target,MinVars=1,MaxVars=1)
	
	WhichBadge = Hat_Ability_Automatic
}