class Cat_SeqCond_IsHUDOpen extends SequenceCondition;

var() class<Hat_HUDElement> HUDClass;
var Actor Target;

event Activated()
{
	local bool IsHUDOpen;
	local Hat_PlayerController PC;

	if (Pawn(Target) != None) Target = Pawn(Target).Controller;
	PC = Hat_PlayerController(Target);
	
	if (Hat_HUD(pc.MyHUD).IsHUDEnabled(HUDClass.Name))
	{
		IsHUDOpen = true;
	}

    OutputLinks[IsHUDOpen ? 0 : 1].bHasImpulse = true;
}

defaultproperties
{
	ObjName="Is HUD Open"
	ObjCategory="Pawn"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target,MinVars=1,MaxVars=1)
	
	HUDClass = class'Hat_HUDElement'
}