class Ban_SeqAct_ChangeOutdoorWetness extends SequenceAction;

var() float NewOutdoorWetness<ClampMin=0.0 | ClampMax=1.0>;
 
event Activated()
{
    local WorldInfo WI;
    local Hat_MapInfo MI;
    
    WI = class'WorldInfo'.static.GetWorldInfo();
    MI = Hat_MapInfo(WI.GetMapInfo());
    if (MI != None)
    {
        MI.OutdoorWetness = NewOutdoorWetness;
        WI.UpdateGenericSceneProxyParameters();        //so the wetness nodes in the materials get refreshed
    }
}
 
defaultproperties
{
    ObjName="Change Outdoor Wetness"
    ObjCategory="Visuals"
    bCallHandler=false
 
    VariableLinks.Empty
}
