class Cat_QualityTime_DW_Timer extends Actor
	placeable
	alwaysloaded;

var bool SurvivalMode;
var Hat_HUDElementDeathWishTimer SurvivalTimer;
var float SurvivalFittestProgress;

var class<Cat_DeathWish_QualityTime_Template> ContractClass; // set the DeathWish script to the script you are using

simulated event PostBeginPlay()
{
	if (ContractClass.static.IsActive())
	SurvivalMode = true;
	else
	SurvivalMode = false;

	Super.PostBeginPlay();
}

simulated event Tick(float D)
{
	if (IsSurvivalMode())
	{
		if (SurvivalTimer != None)
		{
			if (SurvivalFittestProgress >= 0)
			{
				if (SurvivalTimer.CurrentTime < 0)
				{
					SurvivalTimer.SetTime(SurvivalFittestProgress);
					SurvivalTimer.SetCurrentGoal(ContractClass.const.MinGoal);
				}
				SurvivalTimer.UpdateTime(d);
			}
		}
		else if (SurvivalFittestProgress >= 0)
		{
			SurvivalTimer = Hat_HUDElementDeathWishTimer(Hat_HUD(class'WorldInfo'.static.GetWorldInfo().GetALocalPlayerController().myHUD).OpenHUD(class'Hat_HUDElementDeathWishTimer'));
			SurvivalTimer.Objective = ContractClass;
			SurvivalTimer.MinGoal = ContractClass.const.MinGoal;
			SurvivalTimer.MidGoal = ContractClass.const.MidGoal;
			SurvivalTimer.MaxGoal = ContractClass.const.MaxGoal;
			SurvivalTimer.SetCurrentGoal(,true);
			SurvivalTimer.bGolfRules = false;
		}
		ContractClass.static.UpdateSurvival(d, SurvivalFittestProgress);
	}
}

function bool IsSurvivalMode()
{
	return SurvivalMode;
}

defaultproperties
{
	Begin Object Class=SpriteComponent Name=Sprite
		Sprite=Texture2D'HatInTime_Hud_DeathWish.Textures.DWTimer'
		HiddenGame=true
		HiddenEditor=false
		AlwaysLoadOnClient=False
		AlwaysLoadOnServer=False
		Scale = 0.1;
	End Object
	Components.Add(Sprite)
	
   SurvivalFittestProgress = 0;
}