class Cat_DeathWish_QualityTime_Template extends Hat_SnatcherContract_DeathWish;

const MinGoal = 120; // Two Minutes
const MidGoal = 240; // Four Minutes
const MaxGoal = 360; // Six Minutes

const MinGoal_Easy = 60; // One Minute
const MidGoal_Easy = 120; // Two Minutes;
const MaxGoal_Easy = 180; // Three Minutes;

function OnPostInitGame()
{
	Super.OnPostInitGame();
	if (IsExcluded()) return;
	SetObjectiveFailed(0, false);
	SetObjectiveFailed(1, false);
	SetObjectiveFailed(2, false);
}

static function UpdateSurvival(float d, out float Progress)
{
	local bool IsEasyMode;

	if (Progress >= 0)
	{
		IsEasyMode = IsDeathWishEasyMode();
		Progress += d;
		if (Progress >= IsEasyMode ? MinGoal_Easy : MinGoal)
			TriggerObjective(0);
		if (Progress >= IsEasyMode ? MidGoal_Easy : MidGoal)
			TriggerObjective(1);
		if (Progress >= IsEasyMode ? MaxGoal_Easy : MaxGoal)
			TriggerObjective(2);
	}
}

function OnPlayerDeath(Pawn Player)
{
	local Cat_QualityTime_DW_Timer Timer;

	foreach class'worldinfo'.static.GetWorldInfo().DynamicActors(class'Cat_QualityTime_DW_Timer', Timer)
	{
		SetBestTime(Timer.SurvivalFittestProgress, true);
		Timer.SurvivalFittestProgress = -1;
		break;
	}
}

static function bool PromptRetryOnDeath()
{
	return true;
}

static function bool ShouldShowTimer()
{
	return true;
}

defaultproperties
{
	UI_PosX = -0.47
	UI_PosY = -0.4
	
	Objectives(0) = (Title="Objective", Title_EasyMode = "Objective_Easy"); // You'll need to make a Localization file to create a Title and Objectives for your Death Wish, check out how the base game does it and try to figure it out!
	Objectives(1) = (Title="Medium", Title_EasyMode = "Medium_Easy");
	Objectives(2) = (Title="Long", Title_EasyMode = "Long_Easy");
	Conditions = ("Condition")
	TipLocalizedMessage = "Tip0"

	AllowedMaps = ("YOUR_MAP");

	HasEasyMode = true; // if you don't want this to have a P&T, set this to false
	NeverObscureObjectives = true
}