// Janky code by m_cube
class StreamMap_Mod extends GameMod;
 
var string ModMap;
var string MapToStream;
var bool Initialized;

event OnPostInitGame() 
{  
    if (`GameManager.GetCurrentMapFilename() ~= MapToStream)
        RespawnPlayers();
}

event OnModLoaded()
{
    local Array<name> Maps;
    Maps.AddItem(name(MapToStream));
    Maps.AddItem(name(ModMap));

    if (`GameManager.GetCurrentMapFilename() ~= ModMap)
    { 
        class'WorldInfo'.static.GetWorldInfo().PrepareMapChange(Maps);
        class'WorldInfo'.static.GetWorldInfo().CommitMapChange(); 
    }
}

// Try to override loaded map with a custom one...
event OnPreActSelectMapChange(Object ChapterInfo, out int ActID, out String MapName)
{
    if (MapName ~= MapToStream)
        MapName = ModMap;
}

function OnPreRestartMap(out String OutMapName) {
    if (OutMapName ~= MapToStream)
        OutMapName = ModMap;
}


// Should fix most checkpoint issues
function RespawnPlayers()
{
    local Actor p1, p2;
    p1 = class'Engine'.static.GetEngine().GamePlayers[0].Actor;
	
	MoveToCheckpointLocation(p1);

    if (Hat_GameManager(class'WorldInfo'.static.GetWorldInfo().game).IsCoop())
 	{
		p2 = class'Engine'.static.GetEngine().GamePlayers[1].Actor; 
		MoveToCheckpointLocation(p2);
	}
}

function MoveToCheckpointLocation(Actor srcActor)
{
	local Controller C;

	C = Controller(srcActor);
	RespawnPlayer(C);

	if(C != None && C.Pawn != None)
		srcActor = C.Pawn;

	Hat_Player(srcActor).MoveToCheckpointLocation();	
}

function RespawnPlayer(Controller pc) {
	local Pawn NewPawn;
	local Rotator SavedRot;
    SavedRot = pc.Rotation;
	NewPawn = pc.Spawn(pc.Pawn.class,,,pc.Pawn.Location,pc.Pawn.Rotation,,true);
	NewPawn.Health = pc.Pawn.Health;
	if (pc.Pawn.bHidden) 
		NewPawn.SetHidden(true);
	pc.Pawn.Destroy();
	pc.Pawn = None;
	pc.Possess(NewPawn, false);
	pc.SetRotation(SavedRot);
}
 
defaultproperties
{
	ModMap = "example_map" // the map you want to stream to, for ex. example_map
	MapToStream = "mafia_town" // the map you want to stream from, for ex. mafia_town
}
 