class Kido_SeqAct_ChangeAnimTree extends SequenceAction;

var() AnimTree AnimationTree;

static event int GetObjClassVersion()
{
	return Super.GetObjClassVersion()+1;
}

defaultproperties
{
	ObjName="Change Anim Tree"
	ObjCategory="Anim"
    //HandlerName="PlayAnimationAct"
	bCallHandler = false;
	AnimationTree = "None"
	InputLinks(0)=(LinkDesc="Input")
}

event Activated()
{
	local Object t;
	
	foreach Targets(t)
	{
		if (Hat_NPC(t) != None)
			PlayAnimation(Hat_NPC(t).SkeletalMeshComponent);
			
		else if (SkeletalMeshActor(t) != None)
			PlayAnimation(SkeletalMeshActor(t).SkeletalMeshComponent);
		
		else if (Pawn(t) != None)
			PlayAnimation(Pawn(t).Mesh);
	}
}

function PlayAnimation(SkeletalMeshComponent c)
{
	
	if (c.AnimTreeTemplate != AnimationTree)
	{
		c.SetAnimTreeTemplate(AnimationTree);
	}
}

