/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class Ink_SeqCond_IsEasyMode extends SequenceCondition;

var() class<Hat_SnatcherContract_DeathWish> DWClass;

event Activated()
{
    OutputLinks[IsEasyMode(DWClass) ? 0 : 1].bHasImpulse = true;
}

static function bool IsEasyMode(class<Hat_SnatcherContract_DeathWish> Contract)
{
	local Hat_SaveGame SaveGame;

	if (Contract == None) return false;
	if (!Contract.static.IsActive()) return false;

	SaveGame = Hat_SaveGame(`SaveManager.SaveData);
	return Contract.static.IsDeathWishEasyMode(SaveGame);
}


defaultproperties
{
	ObjName="Is Death Wish Easy Mode"
	ObjCategory="Ink Kismet"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
}