Class SS_StatusEffect_FakeBadge extends Hat_StatusEffect;

var Inventory fakeBadge;

function OnAdded(Actor a)
{
    Super.OnAdded(a);
    fakeBadge = Owner.Spawn(Class'SS_Ability_Scriptable',,, vect(0,0,0));
    Hat_InventoryManager(Hat_Player(Owner).InvManager).AddInventory(fakeBadge);
}

simulated function OnRemoved(Actor a)
{
    Hat_InventoryManager(Hat_Player(Owner).InvManager).RemoveFromInventory(fakeBadge);
    fakeBadge.Destroy();
    fakeBadge = None;
    Super.OnRemoved(a);
}

defaultproperties
{
    Duration = -1;
}