Class SS_SequenceCondition_IsA extends SequenceCondition;

/*
* IsA() compare through kismet instead
* Prioritize Connected "Class" input via objects then the specified Class in "CompareClass"
* Returns true if the said compare is the type of Class or considered a child of the class
* Examples:
* Pawn =~ Actor -> True
* Pawn =~ Pawn -> True (Remember it compares if it is the class or a child of the parent class!)
* Actor =~ Pawn -> False (Pawn is a child of Actor not in reverse!)
* Hat_Enemy_Mobster =~ Hat_Enemy -> True
* Hat_Enemy_Mobster =~ Hat_Pawn -> True
* Hat_Player =~ Hat_Enemy -> False (The Player doesn't extend from the Enemy class)
* Hat_Player =~ Hat_Pawn -> True ()
* "Literally any class in that you can touch in the fucking editor" ~= Object -> ALWAYS TRUE
*/

var Object Compare;
var() Class<Object> CompareClass;
var Object Target;

function Activated()
{
    local Name n;
    
    if(Compare != None)
        n = Name(String(Compare.Class));
    else if (CompareClass != None)
        n = Name(String(CompareClass));
    else
        n = '';
    
    OutputLinks[Target.IsA(n) ? 0 : 1].bHasImpulse = true;
}

event CheckForErrors(out Array<string> ErrorMessages)
{
    if(Target == None)
        ErrorMessages.AddItem("No \"Target\" specified or is already returned" @ Target );
    else if(Compare == None && CompareClass == None)
        ErrorMessages.AddItem("No comparison specified through connector OR in the node's properties! \"Compare\" AND \"CompareClass\" returned" @ None);
    Super.CheckForErrors(ErrorMessages);
}

defaultproperties
{
    ObjName="Is Class Type"
    OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target)
	VariableLinks(1)=(ExpectedType=class'SeqVar_Object',LinkDesc="Class",PropertyName=Compare)
}