class mcu8_HUDElement_ProgressBar extends Hat_HUDMenu;

var() string Text;

var() float ProgressValue;
var() float ProgressMaxValue;
var() bool IsVisible;

static function mcu8_HUDElement_ProgressBar Create(HUD H, float def = 0, float max = 100, string defText = "")
{
	local mcu8_HUDElement_ProgressBar ProgressBarHud;
	ProgressBarHud = mcu8_HUDElement_ProgressBar(Hat_HUD(H).OpenHUD(class'mcu8_HUDElement_ProgressBar'));
	ProgressBarHud.UpdateState(def, max, defText);
	return ProgressBarHud;
}

function OnOpenHUD(HUD H, optional String command)
{
	Super.OnOpenHUD(H, command);
}

function SetProgress(float v) {
	ProgressValue = (v > ProgressMaxValue) ? ProgressMaxValue : v;
}

function UpdateState(float currentValue, float maxValue, string newtext) {
	Text = newtext;
	ProgressValue = currentValue;
	ProgressMaxValue = maxValue;
}

function bool Render(HUD H)
{
    local float posX, posY, width, height, CountdownTimeLeft;
    if (!Super.Render(H)) return false;
	if (!IsVisible) return false;
	if (ProgressValue <= 0) return false;
	
    posX = H.Canvas.ClipX/2;
    posY = H.Canvas.ClipY*0.0625+(FMin(H.Canvas.ClipX,H.Canvas.ClipY)*0.02f);

    width = FMin(H.Canvas.ClipX, H.Canvas.ClipY)*0.6;
	height = H.Canvas.ClipY*0.125;

	H.Canvas.Font = class'Hat_FontInfo'.static.GetDefaultFont("");

	H.Canvas.SetDrawColor(255,255,255,255);
	DrawBorderedText(H.Canvas, Text, posX, posY,  0.4*H.Canvas.ClipY * 0.06 * 0.03, true, TextAlign_Center);
  
    CountdownTimeLeft = ProgressValue >= 0 ? (1 - FClamp(ProgressValue / ProgressMaxValue,0,1)) : 0.f;
	RenderProgressBar(H, posX, posY-Height*0.25, Width*0.8, Height*0.060, CountdownTimeLeft);

    return true;
}

function RenderProgressBar(HUD H, float PosX, float PosY, float Width, float Height, float CountdownTimeLeft)
{
	local int OriginalAlpha;
	
	OriginalAlpha = H.Canvas.DrawColor.A;
	
	H.Canvas.SetDrawColor(0,0,0, OriginalAlpha);
	DrawCenter(H, PosX + 1, PosY + 1, Width + 2, Height + 2, H.Canvas.DefaultTexture);
	
	H.Canvas.SetDrawColor(255,255,255, OriginalAlpha);
	DrawCenter(H, PosX, PosY, Width, Height, H.Canvas.DefaultTexture);

	H.Canvas.SetDrawColor(0,0,0, OriginalAlpha*0.5f);
	DrawCenterLeft(H, PosX + Width*0.5*Lerp(1,-1,CountdownTimeLeft), PosY, Width*CountdownTimeLeft, Height, H.Canvas.DefaultTexture);
	
	H.Canvas.DrawColor.A = OriginalAlpha;
}

function bool Tick(HUD H, float d)
{
	if (!Super.Tick(H, d)) return false;
	return true;
}

function bool DisablesMovement(HUD H)
{
	return false;
}

function bool DisablesCameraMovement(HUD H)
{
	return false;
}

defaultproperties
{
	RenderInScreenshots = false
	IsVisible = true
}