class mcu8_SeqAct_ProgressBar extends SequenceAction;

var() string Text<autocomment=true>;
var() float CurrentValue<autocomment=true>;
var() float MaxValue<autocomment=true>;
var() bool VisibleByDefault<autocomment=true>;

var mcu8_HUDElement_ProgressBar ProgressBarHud;

event Activated()
{
    local Object o;
    local Hat_HUD playerHud;
    local mcu8_HUDElement_ProgressBar progressBar;
    foreach Targets(o)
    {
        if (Hat_PlayerController(o) != None)
        {
            playerHud = Hat_HUD(Hat_PlayerController(o).MyHUD);
        }
        else if (Hat_Pawn_Base(o) != None)
        {
            playerHud = Hat_HUD(Hat_PlayerController(Hat_Pawn_Base(o).Controller).MyHUD);
        }

        progressBar = mcu8_HUDElement_ProgressBar(playerHud.GetHUD(class'mcu8_HUDElement_ProgressBar'));
        if (progressBar == None)
        {
            progressBar = class'mcu8_HUDElement_ProgressBar'.static.Create(playerHud, CurrentValue, MaxValue, Text);
            progressBar.IsVisible = VisibleByDefault;
        }
        if (InputLinks[0].bHasImpulse)
        {
            progressBar.UpdateState(CurrentValue, MaxValue, Text);
        }    
        else if (InputLinks[1].bHasImpulse)
        {
            progressBar.IsVisible = true;
        }
        else if (InputLinks[2].bHasImpulse)
        {
            progressBar.IsVisible = false;
        }
    } 

    OutputLinks[0].bHasImpulse = TRUE;
}

defaultproperties
{
	ObjName="Progress Bar"
	ObjCategory="HUD"
    bCallHandler=false;
    bSuppressAutoComment=false;

	VariableLinks.Empty()
	VariableLinks(0)=(ExpectedType=class'SeqVar_String',LinkDesc="Text",PropertyName=Text)
	VariableLinks(1)=(ExpectedType=class'SeqVar_Float',LinkDesc="CurrentValue",PropertyName=CurrentValue)
	VariableLinks(2)=(ExpectedType=class'SeqVar_Float',LinkDesc="MaxValue",PropertyName=MaxValue)
    VariableLinks(3)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Targets)

    InputLinks.Empty()	
	InputLinks(0)=(LinkDesc="Update")
	InputLinks(1)=(LinkDesc="Turn On")
	InputLinks(2)=(LinkDesc="Turn Off")
}