class Ink_SeqAct_ToggleManorMode extends SequenceAction;

static event int GetObjClassVersion()
{
	return Super.GetObjClassVersion()+3;
}

defaultproperties
{
    ObjName="Toggle Manor Mode"
    ObjCategory="Ink Kismet"

    VariableLinks.Empty;

    InputLinks(0)=(LinkDesc="On")
    InputLinks(1)=(LinkDesc="Off")
    InputLinks(2)=(LinkDesc="Toggle")

    OutputLinks(0)=(LinkDesc="Out")

    bCallHandler = false;
}

event Activated()
{
    local WorldInfo wi;
    local Hat_MapInfo mi;
    local Hat_PawnHiding p;

    wi = class'WorldInfo'.static.GetWorldInfo();
    mi = Hat_MapInfo(wi.GetMapInfo());

    if (mi == None)
    {
        ForceActivateOutput(0);
        return;
    }

    if (InputLinks[0].bHasImpulse)
        mi.IsSpooky = true;
    else if (InputLinks[1].bHasImpulse)
        mi.IsSpooky = false;
    else if (InputLinks[2].bHasImpulse)
        mi.IsSpooky = !mi.IsSpooky;

    foreach wi.DynamicActors(class'Hat_PawnHiding', p)
    {
        if (p.Mesh == None) continue;
        ToggleSpookyNodes(p.Mesh, mi.IsSpooky);
    }
}

function ToggleSpookyNodes(SkeletalMeshComponent SkelComp, bool b)
{
	local Hat_AnimBlendBySpooky SpookyNode;

    if (SkelComp == None) return;

    foreach SkelComp.AllAnimNodes(class'Hat_AnimBlendBySpooky', SpookyNode)
        SpookyNode.SetActive(b);
}