/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */


class Ink_SeqCond_CanTakeDamage extends SequenceCondition;

var() bool bWorld;
var() Actor DamageSource;
var() int DamageAmt;

var Array<Actor> Targets;

event Activated()
{
	local bool bAllow;
	local Hat_Pawn PTarget;
	local int i;
    
    bAllow = false;
	for (i = 0; i < Targets.Length; i++)
	{
		PTarget = None;
		if (Hat_Pawn(Targets[i]) != None)
			PTarget = Hat_Pawn(Targets[i]);
		else if (Controller(Targets[i]) != None)
			PTarget = Hat_Pawn(Controller(Targets[i]).Pawn);
		
		if (PTarget == None) continue;

		if (PTarget.CanTakeDamage(bWorld, DamageSource, DamageAmt))
		{
			bAllow = true;
			break;
		}
	}

    OutputLinks[bAllow ? 0 : 1].bHasImpulse = true;
}


defaultproperties
{
	ObjName="Can Take Damage (Insert Mod Name Here)"
	ObjCategory="Combat"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Targets)
	VariableLinks(1)=(ExpectedType=class'SeqVar_Bool',LinkDesc="World Damage",PropertyName=bWorld)
	VariableLinks(2)=(ExpectedType=class'SeqVar_Object',LinkDesc="Source",PropertyName=DamageSource)
	VariableLinks(3)=(ExpectedType=class'SeqVar_Int',LinkDesc="Amount",PropertyName=DamageAmt)
}