class GameMod_AnimSequence_Replacement extends GameMod
	config(Mods);
/*
	This GameMod script replaces existing AnimSequence from AnimSet with one of same name from another AnimSet (or adds it in case AnimSequence with this name does not exist in target AnimSet).
	Since this GameMod modifies actual AnimSets, it affects ALL SkeletalMeshComponent that have use affected AnimSets.
	This procedure may or may not be destructive - it's untested whether changing level with mod disabled restores the original Sequences Array items for affected AnimSets.
	There's also no OnModUnloaded function, so disabling mod won't restore AnimSequences, but it may also cause a crash (which is also untested).
*/
event OnModLoaded()
{
	/*
		Every action that modifies AnimSets should be done in OnModLoaded, so they would occur every time the level is loaded.
		This is an example of usage - replacing single AnimSequence for certain AnimSet.
	*/
	ReplaceAnimSequence(/*Target AnimSet*/, /*AnimSet with new AnimSequence*/, /*AnimSequence Name*/);
}

static function ReplaceAnimSequence(AnimSet OriginalAnimSet, AnimSet ReplacementAnimSet, Name SeqName) //Replaces SeqName AnimSequence in OriginalAnimSet with SeqName AnimSequence from ReplacementAnimSet.
{
	local int i;
	local AnimSequence as;
	if (OriginalAnimSet == None || ReplacementAnimSet == None || SeqName == '')
		return;
	for (i = 0; i < ReplacementAnimSet.Sequences.Length; i++)
	{
		if (ReplacementAnimSet.Sequences[i] != None && ReplacementAnimSet.Sequences[i].SequenceName == SeqName)
		{
			as = ReplacementAnimSet.Sequences[i];
			break;
		}
	}
	if (as == None)
		return;
	for (i = 0; i < OriginalAnimSet.Sequences.Length; i++)
	{
		if (OriginalAnimSet.Sequences[i] != None && OriginalAnimSet.Sequences[i].SequenceName == SeqName)
		{
			OriginalAnimSet.Sequences[i] = as;
			return;
		}
	}
	OriginalAnimSet.Sequences.AddItem(as);
}